<%@ Control Language="c#" AutoEventWireup="false" Codebehind="ListAdvancedGrid.ascx.cs" Inherits="Mediachase.UI.Web.Lists.Modules.ListAdvancedGrid" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ register TagPrefix="dg" namespace="Mediachase.UI.Web.Modules.DGExtension" Assembly="Mediachase.UI.Web" %>
<script language="javascript">
function OpenListSecurityDialog(ListId, FolderId, ProjectId)
{
	var w = 600;
	var h = 300;
	var l = (screen.width - w) / 2;
	var t = (screen.height - h) / 2;
	winprops = 'resizable=0, height='+h+',width='+w+',top='+t+',left='+l;
	var f = window.open('../Lists/ListSecurity.aspx?ListId='+ListId+'&ListFolderId='+FolderId+'&ProjectId='+ProjectId, "_blank", winprops);
}

function DeleteFolder(FolderId)
{
	if(confirm('<%=LocRM.GetString("WarningF")%>'))
	{
		document.forms[0].<%= deletedId.ClientID%>.value = FolderId;
		<%= Page.GetPostBackClientEvent(lbDelFolder, "")%>
	}
}

function DeleteList(ListId)
{
	if(confirm('<%=LocRM.GetString("Warning")%>'))
	{
		document.forms[0].<%= deletedId.ClientID%>.value = ListId;
		<%= Page.GetPostBackClientEvent(lbDelList, "")%>
	}
}

function ImportWizard()
{
	var w = 600;
	var h = 400;
	var l = (screen.width - w) / 2;
	var t = (screen.height - h) / 2;
	winprops = 'resizable=0, height='+h+',width='+w+',top='+t+',left='+l;
	var f = window.open('../wizards/ImportDataWizard.aspx?Type=List', "Wizard", winprops);
}
</script>
<dg:datagridextended id="grdMain" runat="server" allowsorting="True" allowpaging="True" width="100%" autogeneratecolumns="False" PageSize="10" borderwidth="0" gridlines="None" cellpadding="3">
	<columns>
		<asp:boundcolumn datafield="ObjectId" visible="False"></asp:boundcolumn>
		<asp:boundcolumn datafield="Type" visible="False"></asp:boundcolumn>
		<asp:templatecolumn>
			<headerstyle cssclass="ibn-vh2" width="21"></headerstyle>
			<ItemStyle CssClass="ibn-vb2" width="21"></ItemStyle>
			<itemtemplate>
				<img src='<%# DataBinder.Eval(Container.DataItem, "Icon")%>' width="16" height="16" border="0">
			</itemtemplate>
		</asp:templatecolumn>
		<asp:boundcolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" datafield="Name" sortexpression="sortName"></asp:boundcolumn>
		<asp:boundcolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" headerstyle-width="100px" datafield="StatusName" sortexpression="StatusName"></asp:boundcolumn>
		<asp:boundcolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" HeaderStyle-Width="170px" datafield="CreatorName" sortexpression="sortCreator"></asp:boundcolumn>
		<asp:boundcolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" HeaderStyle-Width="120px" datafield="CreationDate" sortexpression="CreationDate" dataformatstring="{0:d}"></asp:boundcolumn>
		<asp:boundcolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" headerstyle-width="23" datafield="ActionMove"></asp:boundcolumn>
		<asp:boundcolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" headerstyle-width="23" datafield="ListSec"></asp:boundcolumn>
		<asp:boundcolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" headerstyle-width="23" datafield="ActionEdit"></asp:boundcolumn>
		<asp:boundcolumn headerstyle-cssclass="ibn-vh2" itemstyle-cssclass="ibn-vb2" headerstyle-width="23" datafield="ActionDelete"></asp:boundcolumn>
	</columns>
</dg:datagridextended>
<input type=hidden id="deletedId" name="deletedId" runat=server />
<asp:LinkButton ID="lbDelFolder" Runat=server Visible=False></asp:LinkButton>
<asp:LinkButton ID="lbDelList" Runat=server Visible=False></asp:LinkButton>